#ifndef _OPENPASSDLG_CPP
#define _OPENPASSDLG_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <Stdio.H>
#include <ShlOBJ.H>
#include <Stdlib.H>

#include "../Resources/Resource.H"

#include "../Source/NSWFL.H"
#include "../Source/Package.H"
#include "../Source/Entry.H"
#include "../Source/Common.H"

#include "../Dialogs/MainDlg.H"
#include "../Dialogs/OpenPassDlg.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//---------------------(Variable Declarations)
HWND OpenPassDialog_hWnd = NULL;

char gsPassword[1024 + 1];

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK OpenPassDialog(HWND xHandle, UINT xMessage, WPARAM wParam, LPARAM lParam)
{
    //--------------------------------------------------------------------------

    static HMENU SystemMenu = NULL;

    static HWND Password_hWnd = NULL;
    static HWND PasswordBitsBar_hWnd = NULL;
    static HWND PasswordBits_hWnd    = NULL;

    //--------------------------------------------------------------------------

    if(xMessage == WM_INITDIALOG) // Received A Initilize Dialog Message
    {
        OpenPassDialog_hWnd = xHandle;

        SystemMenu = GetSystemMenu(xHandle, FALSE);
        AppendMenu(SystemMenu, MF_SEPARATOR, 0, 0);
        AppendMenu(SystemMenu, MF_STRING, 1000, "About");

        SendMessage(xHandle, (UINT)WM_SETTEXT, (WPARAM)0, (LPARAM)gsTitleCaption);
        SendMessage(xHandle, WM_SETICON, TRUE, (LPARAM) LoadIcon(ghAppInstance, MAKEINTRESOURCE(IDI_MAIN)) );

        Password_hWnd = GetDlgItem(xHandle, IDC_PASSWORD);
        PasswordBitsBar_hWnd = GetDlgItem(xHandle, IDC_PASSWORDBAR1);
        PasswordBits_hWnd = GetDlgItem(xHandle, IDC_PASSWORDBITS1);

        SendMessage(Password_hWnd, EM_LIMITTEXT, 1024, 0 );

        Set_Text(Password_hWnd, "9e8t49e8rt4389476i516se56");

        CenterWindow(xHandle);

        return TRUE; // Return TRUE to set the keyboard focus, Otherwise return FALSE
    }

    //--------------------------------------------------------------------------

    if(xMessage == 307) // Key Down
    {
        float PasswordLen    = 0;
        float EffeciencyBits = 0;

        char lsTemp0[64];
        char lsTemp1[64];

        PasswordLen = (float) SendMessage(Password_hWnd, WM_GETTEXTLENGTH, 0, 0);

        EffeciencyBits = (PasswordLen / 56) * 100;
        SendMessage(PasswordBitsBar_hWnd, PBM_SETPOS, (int) EffeciencyBits, 0);

        sprintf(lsTemp0," (%s Bits)", FormatInteger(lsTemp1, (long)(PasswordLen * 8)));
        Set_Text(PasswordBits_hWnd, lsTemp0);
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_COMMAND)
    {
        if(wParam == IDC_OK)
        {
            int Length = Get_TextEx(Password_hWnd, gsPassword, 1024);
            if(Length < 8 || Length > 1024)
            {
                MessageBox(xHandle, "Please enter a password. Within 8 and 1,024 characters.", gsTitleCaption, 0);
                return TRUE;
            }

            EndDialog(xHandle, 1);
            return TRUE;
        }

        if(wParam == IDC_CANCEL)
        {
            EndDialog(xHandle, 0);
            DestroyWindow(xHandle);
            return TRUE;
        }

        return FALSE;
    }

    //--------------------------------------------------------------------------

	if(xMessage == WM_PAINT)
    {
        HDC ThisHDC;
        PAINTSTRUCT ThisPS;

        ThisHDC = BeginPaint(xHandle, &ThisPS);

        // Any painting should be done here

        EndPaint(xHandle, &ThisPS);
        return TRUE;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_SYSCOMMAND) // Received A System Menu Message
    {
        if(LOWORD(wParam) == 1000) //- About (SysMenu Command)
        {
            _AboutDialogInfo ADI;
    
            ADI.DisplayIcon  = LoadIcon(ghAppInstance, MAKEINTRESOURCE(IDI_MAIN));
            ADI.TitleCaption = gsTitleCaption;
            ADI.FileVersion  = gsFileVersion;
            ADI.BuildDate    = __DATE__;
            ADI.BuildTime    = __TIME__;
            ADI.CopyRight    = gsAppCopyRight;
            ADI.OwnerHandle  = xHandle;

            NetLogo(&ADI);
            return TRUE;
        }

        return FALSE;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_CLOSE)  // Received Close Message
    {
        EndDialog(xHandle, 0);
        DestroyWindow(xHandle);
        return TRUE;
    }

    //--------------------------------------------------------------------------

    return FALSE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif

